﻿#if       !defined(INCLUDED_INCLUDED_SZ_VERSION)
#define            INCLUDED_INCLUDED_SZ_VERSION

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

SZ_NS_BEG(szpp)

enum OSVersionConstants
{
  OS_VERSION_2K = 0x0500,
  OS_VERSION_XP = 0x0501,
  OS_VERSION_VISTA = 0x0600,
};

/// <summary>
/// OS のバージョン情報を提供するクラス。
/// </summary>
class SZ_SPEC OSVersion
{
public:

  /// <summary>
  /// デフォルトコンストラクタ。
  /// </summary>
  OSVersion();
  /// <summary>
  /// デストラクタ。
  /// </summary>
  ~OSVersion();

  /// <summary>
  /// OS のバージョン番号を取得するメソッド。フォーマットは _WIN32_WINNT や _WINVER と同じ 0xMMmm 形式。
  /// </summary>
  u32 Get() const { return version; }

  /// <summary>
  /// OS のバージョン番号を取得する静的メソッド。
  /// </summary>
  static u32 GetVersion();

private:

  u32 version;

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_INCLUDED_SZ_VERSION)
